package pack;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import java.util.HashMap;

public class GoogleTest {
    private WebDriver driver;

    @DataProvider(name="keywords")
    public Object[][] data() throws Exception {
        HashMap<String,String[]> dataSet= new TextDriver(System.getProperty("user.dir")+"/data.txt").getData();

        String search1Strings[]=dataSet.get("szukana1");
        String search2Strings[]=dataSet.get("szukana2");
        int size =search1Strings.length;

        // zmodyfikuj liczbę 2 w zależności od liczby wierszy; Tutaj używamy dwóch wierszy 'szukana1' i 'szukana2'
        Object[][] creds = new Object[size][2];
        for(int i=0;i<size;i++)
        {
            creds[i][0]=search1Strings[i];
            creds[i][1]=search2Strings[i];
        }
        return creds;
    }

    @BeforeTest
    public void setUp() throws Exception {
        driver = new ChromeDriver();

    }

    @Test(dataProvider = "slowakluczowe", description = "Google_Test")
    public void search(String search1, String search2) throws Exception {

        driver.get("http://www.google.co.in");

        // wyszukiwanie google z szukana1
        driver.findElement(By.name("q")).clear();
        driver.findElement(By.name("q")).sendKeys("" + search1);
        driver.findElement(By.name("q")).submit();
        Thread.sleep(4000);

        // wyszukiwanie google z szukana2
        driver.findElement(By.name("q")).clear();
        driver.findElement(By.name("q")).sendKeys("" + search2);
        driver.findElement(By.name("q")).submit();
        Thread.sleep(4000);
    }

    @AfterTest
    public void tearDown() throws Exception {
        driver.quit();
    }

}